function X = omp(y, U, N, options)

% INPUT
% y - measurement vector (time domain, dimensions M x 1)
% U - sampling scheme with increment numbers (M x 1)
% N - length of full signal

% PARAMETRES
% options.max_iter - limit of iterations
% options.res ∈(0; ...) - residue norm (should be equal to noise norm)

% OUTPUT
% X (frequency domain, N x 1)

%%%%%%%%%%%% parameters %%%%%%%%%%%%
res = options.res;

if isfield(options, 'max_iter')
    max_iter = options.max_iter;
else
    max_iter = 500;
end

%%%%%%%%%%%% initialization %%%%%%%%%%%%
F = ifft(eye(N)); % inverse Fourier transform matrix
A = F(U, :); % measurement matrix: x = A*y
X = zeros(N, 1);
supp = [];
r = y - A*X;

%%%%%%%%%%%% main loop %%%%%%%%%%%%
for i = 1:max_iter
%     disp(horzcat('iteration', ' ', int2str(i)))
    if norm(r) >= res
        x_omp = abs(A'*(y - A*X));
        [a, Index] = max(x_omp);
        supp = union(supp, Index);
        M = A(:, supp);
        X(supp, 1) = (M'*M)^(-1)*M'*y;
        r = y - A*X;
    else
        disp('stopping criterion has been reached')
        break
    end
end
end
